<?php
defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

/**
 * Hook: woocommerce_before_main_content.
 */
do_action( 'woocommerce_before_main_content' );

/**
 * Hook: woocommerce_shop_loop_header.
 */
do_action( 'woocommerce_shop_loop_header' );

// ======= START SHOP LAYOUT =======
?>
<div class="shop-page-layout">

    <?php if ( is_active_sidebar( 'shop-sidebar' ) ) : ?>
        <aside class="shop-sidebar">
            <?php dynamic_sidebar( 'shop-sidebar' ); ?>
        </aside>
    <?php endif; ?>

    <div class="shop-products">
<?php
// ======= WOOCOMMERCE PRODUCT LOOP =======
if ( woocommerce_product_loop() ) {

    do_action( 'woocommerce_before_shop_loop' );

    woocommerce_product_loop_start();

    if ( wc_get_loop_prop( 'total' ) ) {
        while ( have_posts() ) {
            the_post();

            do_action( 'woocommerce_shop_loop' );

            wc_get_template_part( 'content', 'product' );
        }
    }

    woocommerce_product_loop_end();

    do_action( 'woocommerce_after_shop_loop' );

} else {
    do_action( 'woocommerce_no_products_found' );
}
?>
    </div> <!-- .shop-products -->
</div> <!-- .shop-page-layout -->
<?php
// ======= END SHOP LAYOUT =======

/**
 * Hook: woocommerce_after_main_content.
 */
do_action( 'woocommerce_after_main_content' );

/**
 * Hook: woocommerce_sidebar.
 */
do_action( 'woocommerce_sidebar' );

get_footer( 'shop' );
