<?php
/**
 * Variable product add to cart - Radio Buttons with Selected Class
 *
 * Variations are displayed as radio buttons instead of dropdowns.
 * Selected radio gets a custom class 'selected-radio'.
 *
 * @package WooCommerce\Templates
 * @version 9.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

$attribute_keys  = array_keys( $attributes );
$variations_json = wp_json_encode( $available_variations );
$variations_attr = function_exists( 'wc_esc_json' ) ? wc_esc_json( $variations_json ) : _wp_specialchars( $variations_json, ENT_QUOTES, 'UTF-8', true );

do_action( 'woocommerce_before_add_to_cart_form' ); ?>

<form class="variations_form cart" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->get_id() ); ?>" data-product_variations="<?php echo $variations_attr; ?>">
    <?php do_action( 'woocommerce_before_variations_form' ); ?>

    <?php if ( empty( $available_variations ) && false !== $available_variations ) : ?>
        <p class="stock out-of-stock"><?php echo esc_html( apply_filters( 'woocommerce_out_of_stock_message', __( 'This product is currently out of stock and unavailable.', 'woocommerce' ) ) ); ?></p>
    <?php else : ?>
        <table class="variations" cellspacing="0" role="presentation">
            <tbody>
                <?php foreach ( $attributes as $attribute_name => $options ) : ?>
                    <tr>
                        <th class="label"><label for="<?php echo esc_attr( sanitize_title( $attribute_name ) ); ?>"><?php echo wc_attribute_label( $attribute_name ); ?></label></th>
                        <td class="value">
                            <?php
                            // Default dropdown hidden (WooCommerce logic)
                            wc_dropdown_variation_attribute_options(
                                array(
                                    'options'   => $options,
                                    'attribute' => $attribute_name,
                                    'product'   => $product,
                                )
                            );
                            // Clear variations link
                            echo end( $attribute_keys ) === $attribute_name 
                                ? wp_kses_post( apply_filters( 'woocommerce_reset_variations_link', '<a class="reset_variations" href="#" aria-label="' . esc_attr__( 'Clear options', 'woocommerce' ) . '">' . esc_html__( 'Clear', 'woocommerce' ) . '</a>' ) ) 
                                : '';
                            ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="reset_variations_alert screen-reader-text" role="alert" aria-live="polite" aria-relevant="all"></div>
        <?php do_action( 'woocommerce_after_variations_table' ); ?>

        <div class="single_variation_wrap">
            <?php
                do_action( 'woocommerce_before_single_variation' );
                do_action( 'woocommerce_single_variation' );
                do_action( 'woocommerce_after_single_variation' );
            ?>
        </div>
    <?php endif; ?>

    <?php do_action( 'woocommerce_after_variations_form' ); ?>
</form>

<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>

<!-- JS to convert select to radio buttons with selected class -->
<script type="text/javascript">
jQuery(document).ready(function($){
    $('.variations select').each(function(){
        var select = $(this);
        if(select.siblings('.radio-options').length > 0) return;

        var radioHtml = '<div class="radio-options" style="margin-bottom:15px;">';
        select.find('option').each(function(){
            var val = $(this).attr('value');
            var text = $(this).text();
            if(val){
                var checked = $(this).is(':selected') ? 'checked' : '';
                var activeClass = $(this).is(':selected') ? ' selected-radio' : '';
                radioHtml += '<label class="radio-label'+activeClass+'" style="margin-right:15px; cursor:pointer;"><input type="radio" name="'+select.attr('name')+'" value="'+val+'" '+checked+'> '+text+'</label>';
            }
        });
        radioHtml += '<a href="#" class="reset_variations" style="margin-left:10px;">Clear</a>';
        radioHtml += '</div>';

        select.hide().after(radioHtml);
    });

    // Radio change updates select and toggles selected class
    $('.radio-options input[type=radio]').on('change', function(){
        var $thisLabel = $(this).closest('label');
        var val = $(this).val();
        var $container = $(this).closest('.radio-options');

        // Remove class from all labels
        $container.find('label.radio-label').removeClass('selected-radio');

        // Add class to selected label
        $thisLabel.addClass('selected-radio');

        // Update hidden select
        $container.prev('select').val(val).trigger('change');
    });

    // Clear variations
    $(document).on('click', '.radio-options .reset_variations', function(e){
        e.preventDefault();
        var select = $(this).closest('.radio-options').prev('select');
        $(this).siblings('label').find('input[type=radio]').prop('checked', false);
        $(this).siblings('label.radio-label').removeClass('selected-radio');
        select.val('').trigger('change');
    });
});
</script>

<!-- Optional CSS -->
<style>
.variations select { display: none; }
.radio-options label.radio-label { display: inline-block; margin-bottom: 5px; }
.radio-options label.selected-radio { background: #f0f0f0; border: 1px solid #007cba; padding: 2px 5px; border-radius: 3px; }
.radio-options a.reset_variations { display: inline-block; margin-left: 10px; color: #007cba; text-decoration: underline; cursor: pointer; }
</style>