<?php

function child_styles() {
	wp_enqueue_style( 'my-child-theme-style', get_stylesheet_directory_uri() . '/style.css', array( 'vamtam-front-all' ), false, 'all' );
}
add_action( 'wp_enqueue_scripts', 'child_styles', 11 );


/**
 * Show ACF image + text list below Add to Cart button
 */
add_action( 'woocommerce_after_add_to_cart_button', 'np_show_acf_icons_with_text', 15 );
function np_show_acf_icons_with_text() {
    global $product;
    if ( ! $product ) return;

    $product_id = $product->get_id();

    // Prepare pairs (img1+heading1 ... img5+heading5)
    $items = [];
    for ( $i = 1; $i <= 5; $i++ ) {
        $img  = get_field( 'img' . $i, $product_id );
        $text = get_field( 'heading' . $i, $product_id );

        // Only add if either image or text exists
        if ( !empty($img) || !empty($text) ) {
            $items[] = [
                'img'  => $img,
                'text' => $text
            ];
        }
    }

    // Stop if nothing to show
    if ( empty( $items ) ) return;

    // Output HTML
    echo '<div class="acf-care-instructions" style="margin-top:25px;">';
        echo '<ul class="acf-care-list" style="list-style:none; padding:0;">';
        foreach ( $items as $item ) {
            echo '<li class="acf-care-item" style="display:flex; align-items:center; margin-bottom:8px;">';
                if ( !empty( $item['img'] ) ) {
                    // Support both image array and URL type ACF
                    $img_url = is_array($item['img']) ? $item['img']['url'] : $item['img'];
                    echo '<img src="' . esc_url( $img_url ) . '" alt="" class="acf-care-icon" style="width:24px; height:24px; margin-right:8px;">';
                }
                if ( !empty( $item['text'] ) ) {
                    echo '<span class="acf-care-text" style="font-size:14px; color:#333;">' . esc_html( $item['text'] ) . '</span>';
                }
            echo '</li>';
        }
        echo '</ul>';
    echo '</div>';
}



// ===============================
//  Custom Subscribe Form Shortcode
// ===============================
function custom_subscribe_form_html() {
    ob_start(); ?>

    <div class="subscribe-box" style="max-width:626px;margin:auto;padding:48px;background:#f9f9f9;border-radius:10px;text-align:center;box-shadow:0 0 10px rgba(0,0,0,0.1); height: 400px;">
        <h3 style="font-size:22px;margin-bottom:10px;">Sign up and get 10% off</h3>
        <p style="font-size:15px;color:#555;margin-bottom:20px;">Be the first to know about new collections, exclusive offers and so much more!</p>

        <form method="post">
            <input type="hidden" name="custom_subscribe_form" value="1">
            <input type="text" name="sub_name" placeholder="Name" required style="width:100%;padding:10px;margin-bottom:10px;border:1px solid #ddd;border-radius:5px;">
            <input type="email" name="sub_email" placeholder="Email" required style="width:100%;padding:10px;margin-bottom:10px;border:1px solid #ddd;border-radius:5px;">
            <button type="submit" style="width:100%;padding:12px;background:#333;color:#fff;border:none;border-radius:5px;font-weight:bold;">JOIN THE LIST</button>
        </form>
    </div>

    <?php
    // ✅ Show message after submission
    if ( isset($_GET['subscribed']) && $_GET['subscribed'] == 'true' ) {
        echo '<div style="text-align:center;margin:20px 0;color:green;font-weight:bold;">Thank you for joining! Check your email for the 10% off code.</div>';
    }

    return ob_get_clean();
}
add_shortcode('custom_subscribe_form', 'custom_subscribe_form_html');


// ===============================
//  Handle Form Submission
// ===============================
function custom_subscribe_form_submit() {
    if ( isset($_POST['custom_subscribe_form']) ) {
        global $wpdb;

        $name  = sanitize_text_field($_POST['sub_name']);
        $email = sanitize_email($_POST['sub_email']);
        $coupon = 'DC8WF99Z';
        $table  = $wpdb->prefix . 'subscribers';

        // ✅ Ensure table exists
        custom_create_subscribers_table();

        // ✅ Prevent duplicate entries
        $exists = $wpdb->get_var( $wpdb->prepare("SELECT COUNT(*) FROM $table WHERE email = %s", $email) );
        if ( $exists > 0 ) {
            wp_redirect(add_query_arg('subscribed', 'true', wp_get_referer()));
            exit;
        }

        if ( !empty($email) ) {
            // ✅ Insert subscriber into DB
            $wpdb->insert($table, [
                'name' => $name,
                'email' => $email,
                'date' => current_time('mysql')
            ]);

            // ✅ Send thank-you email to subscriber
            $subject = "Thank you for joining!";
            $message = "Hi $name,\n\nThank you for subscribing to our newsletter!\nUse this coupon code to get 10% OFF: $coupon\n\nBest regards,\n" . get_bloginfo('name');
            $headers = ['Content-Type: text/plain; charset=UTF-8'];

            wp_mail($email, $subject, $message, $headers);

            // ✅ Send notification email to admin
            $admin_email = get_option('admin_email');
            $admin_subject = "New Newsletter Subscriber";
            $admin_message = "A new subscriber joined your list:\n\nName: $name\nEmail: $email";
            wp_mail($admin_email, $admin_subject, $admin_message, $headers);

            // ✅ Redirect to prevent resubmission
            wp_redirect(add_query_arg('subscribed', 'true', wp_get_referer()));
            exit;
        }
    }
}
add_action('template_redirect', 'custom_subscribe_form_submit');


// ===============================
//  Create Subscribers Table
// ===============================
function custom_create_subscribers_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'subscribers';

    if ( $wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name ) {
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE $table_name (
            id mediumint(9) NOT NULL AUTO_INCREMENT,
            name varchar(200) NOT NULL,
            email varchar(200) NOT NULL,
            date datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
            PRIMARY KEY (id)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
}


// ===============================
//  Admin Menu for Subscribers
// ===============================
function custom_subscribers_menu() {
    add_menu_page(
        'Subscribers',
        'Subscribers',
        'manage_options',
        'subscribers-list',
        'custom_subscribers_page',
        'dashicons-email',
        25
    );
}
add_action('admin_menu', 'custom_subscribers_menu');


function custom_subscribers_page() {
    global $wpdb;
    $table = $wpdb->prefix . 'subscribers';
    $results = $wpdb->get_results("SELECT * FROM $table ORDER BY id DESC");

    echo '<div class="wrap"><h1>Newsletter Subscribers</h1>';
    if (empty($results)) {
        echo '<p>No subscribers yet.</p>';
    } else {
        echo '<table class="widefat fixed"><thead><tr><th>ID</th><th>Name</th><th>Email</th><th>Date</th></tr></thead><tbody>';
        foreach ($results as $r) {
            echo '<tr><td>' . $r->id . '</td><td>' . esc_html($r->name) . '</td><td>' . esc_html($r->email) . '</td><td>' . esc_html($r->date) . '</td></tr>';
        }
        echo '</tbody></table>';
    }
    echo '</div>';
}



// Enable classic widgets support
add_theme_support( 'widgets' );

// Register a sidebar for the shop page
function innovecouture_child_register_sidebar() {
    register_sidebar( array(
        'name'          => __( 'Shop Sidebar', 'innovecouture-child' ),
        'id'            => 'shop-sidebar',
        'description'   => __( 'Widgets added here will appear on the WooCommerce shop page.', 'innovecouture-child' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
}
add_action( 'widgets_init', 'innovecouture_child_register_sidebar' );
